Attribute VB_Name = "Module1"
Option Explicit
'
' Brad Martinez,  http://www.mvps.org/ccrp/
'
Public Const CLSID_MyComputer = "{20D04FE0-3AEA-1069-A2D8-08002B30309D}"

Public Const MAX_PATH = 260
Public Const WC_EXPLORER = "ExploreWClass"
Public Const WC_TREEVIEW = "SysTreeView32"

Declare Function IsWindow Lib "user32" (ByVal hWnd As Long) As Long
Declare Function IsWindowVisible Lib "user32" (ByVal hWnd As Long) As Long
Declare Function GetForegroundWindow Lib "user32" () As Long
Declare Function FindWindowEx Lib "user32" Alias "FindWindowExA" (ByVal hwndParent As Long, ByVal hwndChildAfter As Long, ByVal lpszClass As String, ByVal lpszWindow As String) As Long
Declare Function GetClassName Lib "user32" Alias "GetClassNameA" (ByVal hWnd As Long, ByVal lpClassName As String, ByVal nMaxCount As Long) As Long

' If GetLogicalDrives() succeeds, the return value is a bitmask representing
' the currently available disk drives. Bit position 0 (the least-significant bit)
' is drive A, bit position 1 is drive B, bit position 2 is drive C, and so on.
' If the function fails, the return value is zero.
Declare Function GetLogicalDrives Lib "kernel32" () As Long

Declare Function GetDriveType Lib "kernel32" Alias "GetDriveTypeA" (ByVal lpRootPathName As String) As DriveTypes
Public Enum DriveTypes
  DRIVE_UNKNOWN = 0   ' user-defined
  DRIVE_INVALID = 1        ' user-defined
  DRIVE_REMOVABLE = 2   ' reads the drive
  DRIVE_FIXED = 3
  DRIVE_REMOTE = 4   ' reads the drive
  DRIVE_CDROM = 5
  DRIVE_RAMDISK = 6
End Enum

Declare Function GetTickCount Lib "kernel32" () As Long
Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

Declare Function SendMessage Lib "user32" Alias "SendMessageA" _
                            (ByVal hWnd As Long, _
                            ByVal wMsg As Long, _
                            wParam As Any, _
                            lParam As Any) As Long   ' <---

' ============================================================
' treeview

Public Const TV_FIRST = &H1100
Public Const TVM_EXPAND = (TV_FIRST + 2)
Public Const TVM_GETCOUNT = (TV_FIRST + 5)
Public Const TVM_GETNEXTITEM = (TV_FIRST + 10)

Public Enum TVM_EXPAND_wParam
  TVE_COLLAPSE = &H1
  TVE_EXPAND = &H2
  TVE_TOGGLE = &H3

#If (WIN32_IE >= &H300) Then
  TVE_EXPANDPARTIAL = &H4000
#End If
  
  TVE_COLLAPSERESET = &H8000
End Enum

Public Enum TVM_GETNEXTITEM_wParam
  TVGN_ROOT = &H0
  TVGN_NEXT = &H1
  TVGN_PREVIOUS = &H2
  TVGN_PARENT = &H3
  TVGN_CHILD = &H4
  TVGN_FIRSTVISIBLE = &H5
  TVGN_NEXTVISIBLE = &H6
  TVGN_PREVIOUSVISIBLE = &H7
  TVGN_DROPHILITE = &H8
  TVGN_CARET = &H9
#If (WIN32_IE >= &H400) Then
  TVGN_LASTVISIBLE = &HA
#End If
End Enum
'

' Returns the handle of the first child window of the specified parent window
' that is of the classname specifed by sClass.

Public Function GetChildWindowFromClassname(hwndParent As Long, sClass As String) As Long
  Dim hwndChild As Long
  Dim hWnd As Long
  
  ' Get the first child window of the current parent window
  hwndChild = FindWindowEx(hwndParent, 0, vbNullString, vbNullString)
  Do While hwndChild
    
    If IsWindowClassname(hwndChild, sClass) Then
      GetChildWindowFromClassname = hwndChild
      Exit Function
    End If
        
    hWnd = GetChildWindowFromClassname(hwndChild, sClass)
    If hWnd Then
      GetChildWindowFromClassname = hWnd
      Exit Function
    End If
    
    hwndChild = FindWindowEx(hwndParent, hwndChild, vbNullString, vbNullString)
  Loop
  
End Function

' Determines if the window specifed by hWnd is of the classname specifed by sClass.

Public Function IsWindowClassname(hWnd As Long, sClass As String) As Boolean
  Dim sClass1 As String * MAX_PATH
  Dim nChars As Integer
  
  nChars = GetClassName(hWnd, sClass1, MAX_PATH)
  If nChars Then
    IsWindowClassname = (Left$(sClass1, nChars) = sClass)
  End If
  
End Function

' ===========================================================================
' Treeview macros defined in Commctrl.h

' Expands or collapses the list of child items, if any, associated with the specified parent item.
' Returns TRUE if successful or FALSE otherwise.
' (docs say TVM_EXPAND does not send the TVN_ITEMEXPANDING and
' TVN_ITEMEXPANDED notification messages to the parent window...?)

Public Function TreeView_Expand(hWnd As Long, hItem As Long, flag As TVM_EXPAND_wParam) As Boolean
  TreeView_Expand = SendMessage(hWnd, TVM_EXPAND, ByVal flag, ByVal hItem)
End Function

' Returns the count of total items in a tree-view control.

Public Function TreeView_GetCount(hWnd As Long) As Long
  TreeView_GetCount = SendMessage(hWnd, TVM_GETCOUNT, 0, 0)
End Function

' TreeView_GetNextItem

' Retrieves the tree-view item that bears the specified relationship to a specified item.
' Returns the handle to the item if successful or 0 otherwise.

Public Function TreeView_GetNextItem(hWnd As Long, hItem As Long, flag As Long) As Long
  TreeView_GetNextItem = SendMessage(hWnd, TVM_GETNEXTITEM, ByVal flag, ByVal hItem)
End Function

' Retrieves the first child item. The hitem parameter must be NULL.
' Returns the handle to the item if successful or 0 otherwise.

Public Function TreeView_GetChild(hWnd As Long, hItem As Long) As Long
  TreeView_GetChild = TreeView_GetNextItem(hWnd, hItem, TVGN_CHILD)
End Function

' Retrieves the next sibling item.
' Returns the handle to the item if successful or 0 otherwise.

Public Function TreeView_GetNextSibling(hWnd As Long, hItem As Long) As Long
  TreeView_GetNextSibling = TreeView_GetNextItem(hWnd, hItem, TVGN_NEXT)
End Function

' Retrieves the previous sibling item.
' Returns the handle to the item if successful or 0 otherwise.

Public Function TreeView_GetPrevSibling(hWnd As Long, hItem As Long) As Long
  TreeView_GetPrevSibling = TreeView_GetNextItem(hWnd, hItem, TVGN_PREVIOUS)
End Function

' Retrieves the parent of the specified item.
' Returns the handle to the item if successful or 0 otherwise.

Public Function TreeView_GetParent(hWnd As Long, hItem As Long) As Long
  TreeView_GetParent = TreeView_GetNextItem(hWnd, hItem, TVGN_PARENT)
End Function

' Retrieves the first visible item.
' Returns the handle to the item if successful or 0 otherwise.

Public Function TreeView_GetFirstVisible(hWnd As Long) As Long
  TreeView_GetFirstVisible = TreeView_GetNextItem(hWnd, 0, TVGN_FIRSTVISIBLE)
End Function

' Retrieves the next visible item that follows the specified item. The specified item must be visible.
' Use the TVM_GETITEMRECT message to determine whether an item is visible.
' Returns the handle to the item if successful or 0 otherwise.

Public Function TreeView_GetNextVisible(hWnd As Long, hItem As Long) As Long
  TreeView_GetNextVisible = TreeView_GetNextItem(hWnd, hItem, TVGN_NEXTVISIBLE)
End Function

' Retrieves the first visible item that precedes the specified item. The specified item must be visible.
' Use the TVM_GETITEMRECT message to determine whether an item is visible.
' Returns the handle to the item if successful or 0 otherwise.

Public Function TreeView_GetPrevVisible(hWnd As Long, hItem As Long) As Long
  TreeView_GetPrevVisible = TreeView_GetNextItem(hWnd, hItem, TVGN_PREVIOUSVISIBLE)
End Function

' Retrieves the currently selected item.
' Returns the handle to the item if successful or 0 otherwise.

Public Function TreeView_GetSelection(hWnd As Long) As Long
  TreeView_GetSelection = TreeView_GetNextItem(hWnd, 0, TVGN_CARET)
End Function

' Retrieves the item that is the target of a drag-and-drop operation.
' Returns the handle to the item if successful or 0 otherwise.

Public Function TreeView_GetDropHilight(hWnd As Long) As Long
  TreeView_GetDropHilight = TreeView_GetNextItem(hWnd, 0, TVGN_DROPHILITE)
End Function

' Retrieves the topmost or very first item of the tree-view control.
' Returns the handle to the item if successful or 0 otherwise.

Public Function TreeView_GetRoot(hWnd As Long) As Long
  TreeView_GetRoot = TreeView_GetNextItem(hWnd, 0, TVGN_ROOT)
End Function
